# MoonBot for Linux

- [Требования](#requirements)
  - [Установка зависимостей](#requirements-install)
- [Запуск](#launch)
  - [Поддерживаемые дистрибутивы](#supported-distros)
  - [Известные проблемы](#known-issues)
- [Описание](#description)
  - [Технологическая основа: Conty, bubblewrap и user namespaces](#tech-conty)
  - [Файловая система и сохранение изменений](#fs-overlay)
  - [Альтернативный запуск без контейнера](#alt-exec)
  - [Настройка системных параметров](#sysctl)
  - [Опции командной строки](#cli-options)
- [Сборка](#build)

Контейнерный образ, упакованный в один исполняемый файл, предназначенный для запуска MoonBot под Linux с
использованием Wine.

## Требования <a name="requirements"></a>

- Установленные пакеты: `fuse3` (или `fuse`/`fuse2`) и `coreutils`.
- Возможность выполнения файлов из директории `/tmp` (разрешено по умолчанию в большинстве дистрибутивов).
- Ядро Linux с поддержкой user namespaces (требуется для работы контейнера).

### Установка зависимостей <a name="requirements-install"></a>

Для популярных дистрибутивов:

- **Debian/Ubuntu**:

  ```shell
  sudo apt install fuse3 coreutils
  ```

- **RHEL/CentOS/AlmaLinux**:

  ```shell
  sudo dnf install fuse3 coreutils
  ```

## Запуск <a name="launch"></a>

Для корректного старта MoonBot необходимо, чтобы на системе были установлены следующие пакеты:
`fuse3` или `fuse` (версия 2) и `coreutils`.

Также требуется, чтобы файловая система каталога /tmp разрешала выполнение бинарных файлов (не включена опция noexec).
Большинство современных дистрибутивов изначально настроены таким образом.

Запустить MoonBot можно как из терминала, так и посредством графической оболочки. В простейшем случае достаточно выполнить:

```shell
# Для первого запуска сделать файл исполняемым:
chmod +x MoonBot

# Далее просто запускать без опций:
./MoonBot
```

При отсутствии дополнительных параметров командной строки, запускается бот с предустановленными настройками интеграции Wine
и контейнера.

### Поддерживаемые дистрибутивы <a name="supported-distros"></a>

Рекомендуется использовать Debian 12, однако работа была также проверена на следующих дистрибутивах:

- **Debian**: 11, 12
- **Ubuntu** 20.04*, 22.04, 24.04
- **RHEL / CentOS based**^: AlmaLinux 9.5, RockyLinux 9.5

\* - Рекомендуется Ubuntu версии 22.04 и старше  
\^ - Позволяет ожидать совместимость с любыми дистрибутивами, основанными на RHEL версии 9 и выше

### Известные проблемы <a name="known-issues"></a>

- ⚠️ Более новые версии бота на Linux в настоящее время не работают в связи с несовместимостью с Wine.  
  ⛔ **Не обновляйте версию бота**, иначе он может перестать запускаться.  
  Для отката версии в случае обновления можно сделать сброс опцией `-R` и попробовать запустить заново (настройки бота сохраняются):


```shell
./MoonBot -R
./MoonBot
```

## Описание <a name="description"></a>

MoonBot для Linux представляет собой автономный исполняемый контейнерный образ, в который входит минимальный дистрибутив
Arch Linux с предустановленным Wine и необходимыми компонентами для запуска MoonBot, разработанного для Windows.  
Все это упаковано в один исполняемый файл, не требующий установки или дополнительных зависимостей на стороне пользователя.

Основной целью сборки является предоставление стабильного, изолированного и в то же время простого в использовании окружения
для запуска MoonBot под Linux. В отличие от традиционного подхода с ручной установкой Wine и сопутствующих библиотек, данная
сборка обеспечивает полностью готовое к использованию решение, минимизируя вероятность конфликтов с пакетами хоста или различиями
в конфигурации систем. Кроме того, в образе содержится и сам MoonBot для Windows.

Преимущества такого подхода:

- **Упрощённое развёртывание**: Нет необходимости устанавливать актуальные версии Wine и его зависимости,
  которые во многих дистрибутивах либо отсутствуют, либо имеют устаревшие версии.
- **Изоляция окружения**: Все изменения и пользовательские настройки бота сохраняются в отдельном
  рабочем каталоге контейнера, что исключает вмешательство в системные конфигурации хоста.
- **Совместимость**: Контейнер использует только unprivileged user namespaces (благодаря bubblewrap),
  overlayfs и FUSE (версии 2 или 3). Для его работы не требуются инструменты типа Docker.

### Технологическая основа: Conty, bubblewrap и user namespaces <a name="tech-conty"></a>

Контейнер MoonBot основан на проекте [Conty](https://github.com/Kron4ek/Conty) — это минималистичный механизм создания сжатых
контейнеров на базе Arch Linux, которые упаковываются в один исполняемый файл.  
Conty использует [bubblewrap](https://github.com/containers/bubblewrap), overlayfs и другие технологии для обеспечения изоляции,
при этом не требует прав root.  
Подробнее о Conty можно узнать в [его репозитории и сопутствующей документации](https://github.com/Kron4ek/Conty).

### Файловая система и сохранение изменений <a name="fs-overlay"></a>

Образ контейнера изначально является только для чтения, однако при запуске используется OverlayFS,
позволяющий монтировать его в режиме чтения-записи. Все изменения сохраняются в каталоге:

```shell
$HOME/.local/share/MoonBot/overlayfs
```

Рабочий каталог самого MoonBot в контейнере располагается по адресу:

```shell
$HOME/.local/share/MoonBot/overlayfs/opt/MoonBot
```

Это означает, что для резервного копирования или внесения изменений в конфигурационные файлы бота следует
обращаться именно к указанной директории.  
Для удобства в домашнем каталоге пользователя создаётся символическая ссылка:

```shell
$HOME/.config/MoonBot → $HOME/.local/share/MoonBot/overlayfs/opt/MoonBot
```

Таким образом, запуск контейнера никак не затрагивает системные конфигурации Wine или другие настройки
хост ОС.

### Альтернативный запуск без контейнера <a name="alt-exec"></a>

В случае, если в системе уже установлена актуальная версия Wine (желательно версии не ниже 9.x, рекомендуется
версия 10.0 и выше), можно запустить MoonBot напрямую под Wine. Для оптимальной работы рекомендуется также наличие
поддержки vkd3d и всех сопутствующих зависимостей.

Используется версия бота для Windows и просто запускается через Wine указанной конфигруации:

```shell
wine MoonBot.exe
```

### Настройка системных параметров <a name="sysctl"></a>

На некоторых дистрибутивах (например, Ubuntu) могут быть отключены unprivileged user namespaces.  
При обнаружении данной проблемы скрипт запуска контейнера предпримет попытку исправления настроек,
запросив повышение прав (sudo) при первом запуске.  
В случае необходимости, ручное внесение изменений производится следующими командами:

```shell
# Разрешить использование unprivileged user namespaces
sudo sysctl kernel.unprivileged_userns_clone=1

# Для Ubuntu 24.04+ дополнительно:
sudo sysctl kernel.apparmor_restrict_unprivileged_userns=0
```

### Опции командной строки <a name="cli-options"></a>

Контейнер MoonBot поддерживает следующие параметры запуска:

```shell
MoonBot arguments:
  -h          Display this text.
  -r          Reset the container, keep MoonBot workdir and settings
  -R          *CAUTION* Same as above, but attempts to reset overwritten
              MoonBot binaries in the workdir.
              Useful to restore MoonBot after failed update.
  -RESETFULL  *DANGEROUS* Full reset. This will wipe all changes,
              including MoonBot configuration and files in the workdir.
```

- **-r**: Выполняет сброс состояния контейнера, сохраняя при этом рабочий каталог и настройки MoonBot.  
  Однако сбрасывается всё остальное, включая настройки Wine.
- **-R**: Аналог параметра -r, но дополнительно пытается восстановить оригинальные бинарные файлы MoonBot в рабочем
  каталоге. Это полезно при неудачных обновлениях или при возникновении сбоев, требующих восстановления базовых файлов.
- **-RESETFULL**: **ВНИМАНИЕ: ДЕСТРУКТИВНЫЙ РЕЖИМ**.  
  Выполняет полный сброс контейнера, что приводит к удалению всех изменений, включая конфигурационные файлы и
  пользовательские данные, находящиеся в рабочем каталоге.  
  Рекомендуется использовать данный параметр только в случае, когда требуется полностью очистить окружение и начать
  с "чистого листа".

Подробнее ознакомиться с описанием параметров можно, запустив:

```shell
./MoonBot -h
```
